const fs = require('fs')
const wrote = require('wrote')
const makePromise = require('../.')

let file
wrote() // create a temp file and open a writable stream
    .then((ws) => {
        file = ws.path
        console.log(ws.path) // /var/folders/s0/tmp/T/wrote-69822.data
        return new Promise((resolve, reject) => {
            ws.once('close', resolve)
            ws.once('error', reject)
            ws.close()
        })
    })
    .then(() => {
        const promise = makePromise(fs.unlink, file)
        return promise
    })
    .then(
        console.log, // undefined
        console.error
    )
