const fs = require('fs')
const wrote = require('wrote')
const makePromise = require('../.')

let file
wrote() // create a temp file and open a writable stream
    .then((ws) => {
        file = ws.path
        return new Promise((resolve, reject) => {
            ws.once('close', resolve)
            ws.once('error', reject)
            ws.close()
        })
    })
    .then(() => {
        const promise = makePromise(fs.unlink, file, file)
        return promise
    })
    .then(
        (res) => { console.log(res === file) }, // true
        console.error
    )
