const { constants } = require('crypto')
const fs = require('fs')

const mainConfigStr = fs.readFileSync('./api/config/main.json')
const mainConfigObj = JSON.parse(mainConfigStr);
const domain = mainConfigObj.domainName;

const proxy = require('redbird')({
  port: 80,
  bunyan: false,
  letsencrypt: {
    path: 'certs',
    port: 81
  },
  ssl: {
    http2: true,    
    port: 443
  }
});


proxy.register(`app.${domain}`, 'http://localhost:8080', {
  ssl: {    
    letsencrypt: {
      email: `admin@${domain}`,
      production: false,
    }
  }
});


proxy.register(`api.${domain}`, 'http://localhost:8181', {
  ssl: {	
    letsencrypt: {
      email: `admin@${domain}`,
      production: false,
    }
  }
});
